/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit barrel shifter with parallel load
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module barrlstb(q, clk, d, ldst, s);
  output[7:0]	q;
  input[7:0]	d;
  input[2:0]	s;
  input		clk, ldst;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	/* load */
	if ( ldst )
		q_int = d;
	/* shift left */
	else
		case ( s[2:0] )
			3'b000: q_int = q;
			3'b001: q_int = { q[0], q[7:1] };
			3'b010: q_int = { q[1:0], q[7:2] };
			3'b011: q_int = { q[2:0], q[7:3] };
			3'b100: q_int = { q[3:0], q[7:4] };
			3'b101: q_int = { q[4:0], q[7:5] };
			3'b110: q_int = { q[5:0], q[7:6] };
			3'b111: q_int = { q[6:0], q[7] };
		endcase
  specify

`ifdef SYNTH
	specparam area = 8;
`endif

  endspecify
 
endmodule
`endcelldefine



